/*
 * Decompiled with CFR 0.152.
 */
package panther.util.general;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import panther.util.general.AbbreviationEntry;
import panther.util.general.StringUtils;

public class AbbreviationMap {
    protected Map map = new HashMap();

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Collection values() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (AbbreviationEntry abbreviationEntry : this.map.values()) {
            if (!abbreviationEntry.isInUse() && !abbreviationEntry.isLocked()) continue;
            arrayList.add(abbreviationEntry.getValue());
        }
        return arrayList;
    }

    public Object get(String string) {
        AbbreviationEntry abbreviationEntry = this.getEntry(string);
        if (abbreviationEntry.isInUse() || abbreviationEntry.isLocked()) {
            return abbreviationEntry.getValue();
        }
        return null;
    }

    public void add(String string, Object object) {
        AbbreviationEntry abbreviationEntry = this.getEntry(string);
        abbreviationEntry.setValue(object);
        abbreviationEntry.beLocked();
        for (int i = 1; i < string.length(); ++i) {
            String string2 = string.substring(0, i);
            abbreviationEntry = this.getEntry(string2);
            if (abbreviationEntry.isAvailable()) {
                abbreviationEntry.setValue(object);
                continue;
            }
            if (!abbreviationEntry.isInUse()) continue;
            abbreviationEntry.beUnusable();
        }
    }

    public List keysFor(Object object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.map.keySet()) {
            AbbreviationEntry abbreviationEntry = this.getEntry(string);
            if (!abbreviationEntry.isInUse() && !abbreviationEntry.isLocked() || abbreviationEntry.getValue() != object) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public String abbreviationSummary(Object object) {
        return this.abbreviationSummary(object, " ");
    }

    public String abbreviationSummary(Object object, String string) {
        List list = this.keysFor(object);
        Collections.sort(list);
        if (this.isSequence(list)) {
            if (list.size() == 0) {
                return "";
            }
            if (list.size() == 1) {
                return list.get(0).toString();
            }
            if (list.size() == 2) {
                return StringUtils.concatenate(list, string);
            }
            return list.get(0) + " ... " + list.get(list.size() - 1);
        }
        return StringUtils.concatenate(list, string);
    }

    protected boolean isSequence(List list) {
        if (list.isEmpty()) {
            return true;
        }
        String string = (String)list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            if (!string2.startsWith(string)) {
                return false;
            }
            string = string2;
        }
        return true;
    }

    protected Map toMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.map.size());
        for (String string : this.map.keySet()) {
            AbbreviationEntry abbreviationEntry = (AbbreviationEntry)this.map.get(string);
            if (!abbreviationEntry.isInUse() && !abbreviationEntry.isLocked()) continue;
            hashMap.put(string, abbreviationEntry.getValue());
        }
        return hashMap;
    }

    protected AbbreviationEntry getEntry(String string) {
        AbbreviationEntry abbreviationEntry = (AbbreviationEntry)this.map.get(string);
        if (abbreviationEntry == null) {
            abbreviationEntry = new AbbreviationEntry();
            this.map.put(string, abbreviationEntry);
        }
        return abbreviationEntry;
    }
}

